<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Faq_Controller
{
  private $Faq_Manager;

  public function __construct()
  {
    $this->Faq_Manager = new Ultimate_AI_Faq();
    add_action('wp_ajax_ultimate_ai_create_faq', [$this, 'ultimate_ai_create_faq']);
    add_action('wp_ajax_ultimate_ai_get_all_faq_items', [$this, 'ultimate_ai_get_all_faq_items']);
    add_action('wp_ajax_ultimate_ai_update_faq_status', [$this, 'ultimate_ai_update_faq_status']);
    add_action('wp_ajax_ultimate_ai_delete_faq', [$this, 'ultimate_ai_delete_faq']);
  }

  public function ultimate_ai_create_faq()
  {
    restrict_req_for_admin();
    $question = sanitize_text_field($_POST['question']);
    $answer = sanitize_text_field($_POST['answer']);
    $id = sanitize_text_field($_POST['id']);
    $res = $this->Faq_Manager->ultimate_ai_create_faq($question, $answer, $id);

    if (!$res['is_success']) {
      wp_send_json(['data' => $res['message']], 400);
    }
    wp_send_json(['data' => $res['data']], 200);
  }

  public function ultimate_ai_get_all_faq_items()
  {
    $faqs = $this->Faq_Manager->ultimate_ai_get_all_faqs();
    wp_send_json(['is_success' => true, 'data' => $faqs], 200);
  }

  // ===================== update faq status ==================
  public function ultimate_ai_update_faq_status()
  {
    restrict_req_for_admin();
    $key_name = sanitize_key($_POST['key_name']);
    $value = rest_sanitize_boolean($_POST['value']);
    $faq_id = (int) sanitize_text_field($_POST['faq_id']);
    $is_direct_meta = true; // hard coded for now
    $res = $this->Faq_Manager->ultimate_ai_update_faq_meta($key_name, $value, $faq_id, $is_direct_meta);

    if (!$res['is_success']) {
      wp_send_json(['data' => $res['message']], 400);
    }

    wp_send_json(['data' => $res['data']], 200);
  }

  // ========= Delete chat assistant =========================
  public function ultimate_ai_delete_faq()
  {
    restrict_req_for_admin();
    $faq_id = (int) sanitize_text_field($_POST['id']);

    $delete_result = $this->Faq_Manager->ultimate_ai_delete_faq_item($faq_id);

    if (!$delete_result['success']) {
      wp_send_json(['data' => 'Chat assistant deletion failed. ' . $delete_result['message']], 400);
    }

    wp_send_json(['data' => 'Chat assistant deleted successfully'], 200);
  }
}
new Ultimate_AI_Faq_Controller();
